<?php

namespace V360\ShowComponents;

use Illuminate\Support\ServiceProvider;

class ShowComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {

    if ($this->app->runningInConsole()) {
      // Publish view components
      $this->publishes([
        __DIR__ . '/../src/View/Components/' => app_path('View/Components/vshow'),
        __DIR__ . '/../resources/views/components/' => resource_path('views/components/vshow'),
      ], 'vshow');
    }
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {

    // ... other things
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vshow');

    //regiter components
    $this->loadViewComponentsAs('vshow', [
      \V360\ShowComponents\View\Components\Alert::class,
      \V360\ShowComponents\View\Components\Breadcrumb::class,
      \V360\ShowComponents\View\Components\Collection::class,
      \V360\ShowComponents\View\Components\ContainerEnum::class,
      \V360\ShowComponents\View\Components\ContainerIconList::class,
      \V360\ShowComponents\View\Components\ContainerLabel::class,
      \V360\ShowComponents\View\Components\DividerIcon::class,
      \V360\ShowComponents\View\Components\Features::class,
      \V360\ShowComponents\View\Components\Icon::class,
      \V360\ShowComponents\View\Components\IconFa::class,
      \V360\ShowComponents\View\Components\IconHelp::class,
      \V360\ShowComponents\View\Components\IconLabel::class,
      \V360\ShowComponents\View\Components\Info::class,
      \V360\ShowComponents\View\Components\InfoCount::class,
      \V360\ShowComponents\View\Components\InfoIcon::class,
      \V360\ShowComponents\View\Components\InfoList::class,
      \V360\ShowComponents\View\Components\Loading::class,
      \V360\ShowComponents\View\Components\Modalshow::class,
      \V360\ShowComponents\View\Components\Norecords::class,
      \V360\ShowComponents\View\Components\Notfound::class,
      \V360\ShowComponents\View\Components\Status::class,
      \V360\ShowComponents\View\Components\TagDual::class,
      \V360\ShowComponents\View\Components\TagIcon::class,
      \V360\ShowComponents\View\Components\Timestamps::class,
      \V360\ShowComponents\View\Components\Userstamps::class,
      \V360\ShowComponents\View\Components\VideoStreamPlayer::class,
    ]);
  }
}
