<div class="p-4">
    @if ($label)
        <div class="is-flex is-align-items-center">
            <span class="icon is-small mr-3">
                @if (Str::startsWith($icon, 'fa'))
                    <i class="{{ $icon }}"></i>
                @else
                    <span class="material-symbols-outlined is-size-6">
                        {{ $icon }}
                    </span>
                @endif
            </span>
            <span class="is-size-7 is-italic">
                {{ $label }}
            </span>
        </div>
    @endif
    <ul class="{{ $label ? 'pl-5 ml-1' : '' }}">
        @if ($items)
            @foreach ($items as $label => $value)
                <li class="my-3">
                    @if (!$keys)
                        <span class="tag is-medium {{ $color }}">{{ $value ?? '-' }}</span>
                    @else
                        <div class="level is-mobile">
                            <div class="level-left">
                                <div class="level-item pr-2">
                                    <p class="subtitle is-6">{{ $keys ? $label : '' }}</p>
                                </div>
                                @if ($align == 'left')
                                    <div class="level-item">
                                        <span class="tag is-medium {{ $color }}">{{ $value ?? '-' }}</span>
                                    </div>
                                @endif
                            </div>
                            @if ($align == 'right')
                                <div class="level-right">
                                    <div class="level-item">
                                        <span class="tag is-medium {{ $color }}">{{ $value ?? '-' }}</span>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif
                </li>
            @endforeach
        @endif
    </ul>
</div>
