<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class TagDual extends Component
{
  /**
   * Create a new TagDual component instance.
   *
   * @param string  $key    The key/label text for the first part of the dual tag
   * @param ?string $value  Optional value text for the second part of the dual tag
   * @param string  $size   Size of the tag ('small', 'normal', 'medium', 'large') (default: 'normal')
   * @param bool    $margin Whether to apply margin to the tag (default: true)
   * @param string  $color  Color theme of the tag (default: 'info')
   * 
   * @return void
   */
  public function __construct(
    public string $key,
    public ?string $value = null,
    public string $size = 'normal',
    public bool $margin = true,
    public string $color = 'info'
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.tag-dual');
  }
}
