<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Status extends Component
{

  /**
   * Create a new Status component instance.
   *
   * @param string  $status The status text to display
   * @param bool    $icon   Whether to show an icon (default: true)
   * @param string  $class  CSS class for styling (default: 'is-info')
   * @param bool    $label  Whether to show as a label (default: false)
   * @param ?string $size   Optional size modifier for the status
   * 
   * @return void
   */
  public function __construct(
    public string $status,
    public bool $icon = true,
    public string $class = 'is-info',
    public bool $label = false,
    public ?string $size = null
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.status');
  }
}
