<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class InfoList extends Component
{

  /**
   * Create a new InfoList component instance.
   *
   * @param mixed    $items          List of items to display in the info list
   * @param ?string  $labelClasses   CSS classes for the labels (default: 'is-italic has-text-info-dark has-text-right')
   * @param ?string  $contentClasses CSS classes for the content/values
   * 
   * @return void
   */
  public function __construct(
    public mixed $items,
    public ?string $labelClasses = 'is-italic has-text-info-dark has-text-right',
    public ?string $contentClasses = null
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\Contracts\View\View|string
   */
  public function render()
  {
    return view('vshow::components.info-list');
  }
}
