<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Alert extends Component
{

  /**
   * Create a new Alert component instance.
   *
   * @param string $message The alert message to be displayed
   * @param string $icon    The icon to be shown (default: 'info')
   * @param string $color   The color theme of the alert (default: 'info')
   * 
   * @return void
   */
  public function __construct(
    public string $message,
    public string $icon = 'info',
    public string $color = 'info',
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.alert');
  }
}
