<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Info extends Component
{

  public ?string $label = null;
  public ?string $value = null;
  public ?string $icon = null;
  public string $type = 'text';
  public string $classes = 'has-text-black';
  public string $align = 'left';
  public bool $isUrl = false;

  /**
   * Create a new component instance.
   *
   * @param string $label
   * @param string $value
   * @param string $icon
   * @param string $type - text | amount | timestamp | date
   * @param string $classes
   * @param string $align
   * @param bool $isUrl
   */
  public function __construct(
    string $label = null,
    string $value = null,
    string $icon = null,
    string $type = 'text',
    string $classes = 'has-text-black',
    string $align = 'left',
    bool $isUrl = false
  ) {
    //
    $this->label = $label;
    $this->value = $value;
    $this->icon = $icon;
    $this->classes = $classes;
    $this->align = $align;
    $this->isUrl = $isUrl;

    if (!$icon) {
      switch ($type) {
        case 'amount':
          $this->icon = "currency_rupee";
          $this->align = "right";
          break;
        case 'timestamp':
          $this->icon = "schedule";
          break;
        case 'date':
          $this->icon = "today";
          break;
        default:
          $this->icon = 'short_text';
          break;
      }
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.info');
  }
}
