<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ContainerLabel extends Component
{
  /**
   * Create a new component instance.
   *
   * @param string|null $label Label for the container
   * @param string|null $icon Icon for the container
   * @param string $color Background color of the label
   * @param int|null $height Height of the container, in case of fixed height
   */
  public function __construct(
    public ?string $label = null,
    public ?string $icon = null,
    public string $color = 'light',
    public ?int $height = null,
  ) {
    //
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.container-label');
  }
}
