<?php

namespace V360\ShowComponents;

use Illuminate\Support\ServiceProvider;
use V360\ShowComponents\View\Components\Breadcrumb;
use V360\ShowComponents\View\Components\Collection;
use V360\ShowComponents\View\Components\ContainerEnum;
use V360\ShowComponents\View\Components\ContainerIconList;
use V360\ShowComponents\View\Components\ContainerLabel;
use V360\ShowComponents\View\Components\DividerIcon;
use V360\ShowComponents\View\Components\Features;
use V360\ShowComponents\View\Components\IconFa;
use V360\ShowComponents\View\Components\IconHelp;
use V360\ShowComponents\View\Components\IconMaterial;
use V360\ShowComponents\View\Components\Info;
use V360\ShowComponents\View\Components\InfoCount;
use V360\ShowComponents\View\Components\InfoIcon;
use V360\ShowComponents\View\Components\InfoList;
use V360\ShowComponents\View\Components\Loading;
use V360\ShowComponents\View\Components\Modalshow;
use V360\ShowComponents\View\Components\Norecords;
use V360\ShowComponents\View\Components\Notfound;
use V360\ShowComponents\View\Components\Status;
use V360\ShowComponents\View\Components\TagDual;
use V360\ShowComponents\View\Components\TagIcon;
use V360\ShowComponents\View\Components\Timestamps;
use V360\ShowComponents\View\Components\Userstamps;

class ShowComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {

    if ($this->app->runningInConsole()) {
      // Publish view components
      $this->publishes([
        __DIR__ . '/../src/View/Components/' => app_path('View/Components/vshow'),
        __DIR__ . '/../resources/views/components/' => resource_path('views/components/vshow'),
      ], 'vshow');
    }
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {

    // ... other things
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vshow');

    //regiter components
    $this->loadViewComponentsAs('vshow', [
      Breadcrumb::class,
      Collection::class,
      ContainerEnum::class,
      ContainerIconList::class,
      ContainerLabel::class,
      DividerIcon::class,
      Features::class,
      IconFa::class,
      IconHelp::class,
      IconMaterial::class,
      Info::class,
      InfoCount::class,
      InfoIcon::class,
      InfoList::class,
      Loading::class,
      Modalshow::class,
      Norecords::class,
      Notfound::class,
      Status::class,
      TagDual::class,
      TagIcon::class,
      Timestamps::class,
      Userstamps::class,
    ]);
  }
}
