<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Status extends Component
{

    public string $status;
    public bool $icon;
    public string $class;
    public string $label;
    public ?string $size = null;

    /**
     * Create a new component instance.
     *
     * @param string $status
     * @param boolean $icon
     * @param string $class
     * @param boolean $label
     * @param string $size
     */
    public function __construct(
        string $status,
        bool $icon = true,
        string $class = 'is-info',
        bool $label = false,
        string $size = null
    ) {
        $this->status = $status;
        $this->icon = $icon;
        $this->class = $class;
        $this->label = $label;
        $this->size = $size;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\View\View|string
     */
    public function render()
    {
        return view('vshow::components.status');
    }
}
