<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ContainerEnum extends Component
{
  /**
   * Create a new ContainerEnum component instance.
   *
   * @param string $label    The label for the enum container
   * @param array  $cases    Array of enum cases to display
   * @param bool   $useColor Whether to use color coding for cases (default: false)
   * 
   * @return void
   */
  public function __construct(
    public string $label,
    public array $cases,
    public bool $useColor = false
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.container-enum');
  }
}
