<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Collection extends Component
{
  /**
   * Create a new Collection component instance.
   *
   * @param mixed    $items The collection of items to display
   * @param bool     $keys  Whether to show array keys (default: true)
   * @param string   $color The color theme of the collection (default: 'is-info')
   * @param string   $align Text alignment within the collection (default: 'left')
   * @param ?string  $label Optional label for the collection
   * @param ?string  $icon  Optional icon for the collection (default: 'short_text' if label is set)
   * 
   * @return void
   */
  public function __construct(
    public mixed $items,
    public bool $keys = true,
    public string $color = 'is-info',
    public string $align = 'left',
    public ?string $label = null,
    public ?string $icon = null
  ) {
    $this->icon = $icon ?? 'short_text';
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.collection');
  }
}
