<div wire:ignore>
    <video class="video-stream-player" id="{{ $id }}" {{ $attrs }} data-url="{{ $url }}"
        style="width: 100%; height: auto;"></video>
    @script
        <script type="module">
            $(document).ready(function() {
                function initializeHls(videoElement, url, startPlay = true) {
                    const hls = new Hls();
                    // bind them together
                    hls.attachMedia(videoElement);
                    // MEDIA_ATTACHED event is fired by hls object once MediaSource is ready
                    hls.on(Hls.Events.MEDIA_ATTACHED, () => {
                        console.debug('video and hls.js are now bound together !');
                        //load source
                        hls.loadSource(url);
                    });
                    hls.on(Hls.Events.MANIFEST_PARSED, (event, data) => {
                        console.debug(
                            'manifest loaded, found ' + data.levels.length + ' quality level',
                        );
                        if (startPlay) {
                            videoElement.play()
                        }
                    });
                }

                let isFirst = true
                $('video.video-stream-player').each(function() {
                    const streamUrl = $(this).data('url');
                    initializeHls(this, streamUrl, isFirst ? true : false);
                    isFirst = false;
                });

                Livewire.on('UpdateStreamUrl', ({
                    id,
                    url
                }) => {
                    const videoElement = document.getElementById(id);
                    initializeHls(videoElement, url, true);
                })
            });
        </script>
    @endscript
</div>
