<?php

namespace V360\LivewireComponents;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

use V360\LivewireComponents\View\Livewire\AutoComplete;

class LivewireComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {
    //merge config
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {
    //register views as `vlw`, this key should be used in render function
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vlw');

    //register livewire components
    Livewire::component('vlw-autocomplete', AutoComplete::class);
  }
}
