<div>
    <style>
        #auto-selector.dropdown {
            position: absolute;
            width: 100%;
        }

        #auto-selector .dropdown-menu {
            width: 100%;
            padding-top: 0px;
        }

        #auto-selector .dropdown-content {
            max-height: 200px;
            overflow-y: scroll;
            border-radius: 8px;
        }

        #auto-selector .dropdown-content::-webkit-scrollbar {
            width: 4px;
        }

        #auto-selector .dropdown-content::-webkit-scrollbar-track {
            background-color: #eee;
            border-radius: 8px;
        }

        #auto-selector .dropdown-content::-webkit-scrollbar-thumb {
            background-color: #ccc;
            border-radius: 8px;
        }

        #auto-selector .dropdown-item.is-focused {
            background: hsl(0, 0%, 96%)
        }
    </style>
    <div class="is-relative" id="{{ $context }}">
        <div class="field is-relative">
            @if ($label)
                <label for="{{ $context }}" class="label">{{ $label }}</label>
            @endif
            <p class="control has-icons-left has-icons-right">
                <input class="input is-normal" type="text" placeholder="{{ $placeholder }}"
                    wire:model.live.debounce.1000ms="query" id="query" autocomplete="off">
                <span class="icon is-small is-left">
                    <i class="fas fa-magic"></i>
                </span>
                @if ($allowNew && $autoItems->isEmpty())
                    <span class="icon is-small is-right is-clickable" wire:click="add" title="Add">
                        <i class="fas fa-plus-square has-text-info"></i>
                    </span>
                @else
                    <span class="icon is-small is-right is-clickable" wire:click="clear">
                        <i class="fas fa-times"></i>
                    </span>
                @endif
            </p>
            <div class="dropdown {{ $isActive ? 'is-active' : '' }}" id="auto-selector">
                <div class="dropdown-menu" role="menu">
                    <div class="dropdown-content" id="items">
                        @if ($autoItems->isEmpty())
                            <div class="dropdown-item">
                                No items found. {{ $allowNew ? 'Click plus to add it.' : '' }}
                            </div>
                        @else
                            @foreach ($autoItems as $value => $label)
                                <a href="#" class="dropdown-item" data-value="{{ $value }}"
                                    data-label="{{ $label }}">
                                    {{ $label }}
                                </a>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @script
        <script>
            const context = "{{ $context }}"
            const $context = $(`#${context}`)
            const $query = $('#query', $context)
            const $selector = $('#auto-selector', $context)
            const $dropdown = $('#items', $context)

            const activateAuto = () => {
                const $items = $('a.dropdown-item', $context)
                let $focused;
                if ($query.val()) {
                    $focused = $(`.dropdown-item[data-label="${$query.val()}"]`, $context)
                }
                if (!$focused || $focused.length == 0) {
                    $focused = $('.dropdown-item.is-focused', $context)
                    if ($focused.length == 0) {
                        $focused = $($items[0])
                    }
                }
                $items.removeClass('is-focused')
                $focused.addClass('is-focused')
                $selector.addClass('is-active')
                return $focused
            }
            const deactivateAuto = () => {
                $selector.removeClass('is-active')
            }
            const init = () => {
                $query.on('click', activateAuto)
                $query.on('focus', activateAuto)
                $query.on('keydown', (event) => {
                    if (event.code == 'ArrowDown') {
                        event.preventDefault()
                        const $focused = activateAuto()
                        $focused.focus()
                    }
                    if (event.code == 'Escape') {
                        event.preventDefault()
                        deactivateAuto()
                    }
                })
                $dropdown.on('keydown', (event) => event.preventDefault())
                $query.on('focusout', (event) => {
                    setTimeout(() => {
                        const $focused = $(':focus');
                        if (!$focused.hasClass('dropdown-item')) {
                            deactivateAuto()
                        }
                    }, 100);
                });
            }
            const selectItem = (target) => {
                const value = target.dataset.value
                const label = target.dataset.label
                $query.val(label)
                window.Livewire.dispatch('AutoCompleteSelected', {
                    context,
                    value,
                    label
                })
                deactivateAuto()
            }
            const onKey = (event) => {
                event.preventDefault()
                // console.log(`onKey`, event);
                const $this = $(event.target)
                switch (event.code) {
                    case 'ArrowDown':
                        const $next = $this.next()
                        if ($next.length > 0) {
                            $next.addClass('is-focused')
                            $next.focus()
                            $this.removeClass('is-focused')
                        }
                        break;
                    case 'ArrowUp':
                        const $previous = $this.prev()
                        if ($previous.length > 0) {
                            $previous.addClass('is-focused')
                            $previous.focus()
                            $this.removeClass('is-focused')
                        }
                        break;
                    case 'Enter':
                        // console.log('onKey : ', event.target)
                        selectItem(event.target)
                        break;
                    default:
                        break;
                }
            }
            const onClick = (event) => {
                event.preventDefault()
                // console.log('onClick : ', event.target)
                selectItem(event.target)
            }
            const refresh = () => {
                const $items = $('a.dropdown-item', $context)
                $items.off('click').on('click', onClick)
                $items.off('keydown').on('keydown', onKey)
            }
            init();
            refresh();

            window.Livewire.on('ActivateAutocomplete', event => {
                setTimeout(() => {
                    refresh();
                }, 50);
            })
        </script>
    @endscript
</div>
