<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;

/**
 * ReCaptcha Laravel Blade Component
 *
 * A reCaptcha component to integrate Google's reCaptcha service.
 * Supports both v2 and v3 versions for enhanced security against bots.
 *
 * Features:
 * - Supports reCaptcha v2 and v3
 * - Easy integration with forms
 * - Customizable version selection
 * - Bulma CSS framework integration
 * - Mobile-friendly responsive design
 *
 * @package V360\FormComponents\View\Components
 * @author V360
 * @version 1.0.0
 * @since 2024-08-01
 *
 * @example
 * <!-- reCaptcha v2 -->
 * <x-vform-re-captcha version="v2" />
 *
 * <!-- reCaptcha v3 -->
 * <x-vform-re-captcha version="v3" />
 *
 */
class ReCaptcha extends Component
{

  /**
   * Version of reCaptcha 
   *
   * @var string
   */
  public string $version;

  /**
   * Create a new component instance.
   *
   * @param string $version
   */
  public function __construct($version = 'v3')
  {
    //
    $this->version = $version;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.re-captcha');
  }
}
