<div>
    @if ($label)
        <label for="{{ $id }}" class="label">{{ $label }}</label>
    @endif
    <div class="field has-addons">
        <div class="control has-icons-left">
            <input type="password" id="{{ $id }}" name="{{ $name }}" value="{{ $value }}"
                class="input" autocomplete="off" {{ $attributes }}>
            <span class="icon is-small is-left">
                <span class="material-symbols-outlined is-size-6">
                    key
                </span>
            </span>
        </div>
        @if ($show)
            <p class="control">
                <a class="button show-password has-background-light" id="show-{{ $id }}">
                    <span class="icon is-small is-left">
                        <span class="material-symbols-outlined is-size-6">
                            visibility
                        </span>
                    </span>
                </a>
            </p>
        @endif
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
    <script type="module">
        $(document).ready(function() {
            const initPasswordControls = (controlId) => {
                const $control = $(controlId)
                $control.on('mousedown', function() {
                    const control = $('input[type=password]', $(this).parent().parent());
                    control.attr('type', 'text')
                })
                $control.on('mouseup', function() {
                    const control = $('input[type=text]', $(this).parent().parent());
                    control.attr('type', 'password')
                })
            }
            initPasswordControls('a#show-{{ $id }}');
        });
    </script>
</div>
