<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

/**
 * InputSwitch Laravel Blade Component
 *
 * An input switch (toggle) component that allows users to switch between two states.
 * Features customizable labels, colors, and hints for enhanced user experience.
 *
 * Features:
 * - Toggle switch functionality
 * - Customizable labels and colors
 * - Form validation integration
 * - Livewire real-time updates
 * - Bulma CSS framework integration
 * - Mobile-friendly responsive design
 *
 * @package V360\FormComponents\View\Components
 * @author V360
 * @version 1.0.0
 * @since 2024-06-30
 *
 * @example
 * <!-- Input switch -->
 * <x-vform-input-switch 
 *     name="enable_feature" 
 *     label="Enable Feature" 
 *     color="success" 
 *     hint="Toggle to enable or disable the feature." 
 * />
 *
 */
class InputSwitch extends Component
{

  /**
   * The unique ID of the input switch.
   * @var string
   */
  public string $id;

  /**
   * Create a new component instance.
   * @param string $name Name of the input
   * @param string $label Label of the input
   * @param string $color Color of the input switch
   * @param mixed $hint Hint for the input
   */
  public function __construct(
    public string $name,
    public string $label,
    public string $color = 'info',
    public ?string $hint = null
  ) {
    $this->id = Str::uuid();
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.input-switch');
  }
}
