<div wire:ignore id="irt-{{ $name }}">
    <div class="field">
        @if ($label || !$readOnly)
            <div class="control is-flex is-align-items-center mb-5">
                <label class="label is-medium mb-0">
                    {{ $label }}
                </label>
                @if (!$readOnly)
                    <button class="button is-small is-warning ml-2" id="edit">
                        <x-vshow-icon>edit</x-vshow-icon>
                        <span>Edit</span>
                    </button>
                    <button class="button is-small is-link ml-2 is-hidden" id="done">
                        <x-vshow-icon>check</x-vshow-icon>
                        <samp>Done</samp>
                    </button>
                @endif
            </div>
        @endif
        <div id="{{ $name }}"></div>
        @if (!$livewire)
            <input type="hidden" name="{{ $name }}">
        @endif
    </div>

    <script type="module">
        $(document).ready(function() {
            let editor;
            const id = @json($name);
            const $context = $(`#irt-${id}`);
            const content = @json($content);
            const readOnly = Boolean(@json($readOnly));

            const readText = (content) => {
                const options = {
                    readOnly: true,
                    theme: 'bubble'
                };
                editor = new Quill(`#${id}`, options)
                if (content) {
                    editor.setContents(content)
                }
            }

            const writeText = (content) => {
                const toolbarOptions = @json($toolbarOptions);
                const options = {
                    modules: {
                        toolbar: toolbarOptions
                    },
                    theme: 'snow'
                };
                editor = new Quill(`#${id}`, options)
                if (content) {
                    editor.setContents(content)
                }
                editor.enable(false);
            }

            $('button#edit', $context).on('click', function() {
                editor.enable();
                $('button#edit', $context).addClass('is-hidden')
                $('button#done', $context).removeClass('is-hidden')
                const startEdit = new CustomEvent('StartRichEdit', {
                    detail: {
                        id
                    }
                });
                document.dispatchEvent(startEdit);
            });

            $('button#done', $context).on('click', function() {
                const delta = editor.getContents()
                if (window.Livewire) {
                    Livewire.dispatch(`ChangeRichText:${id}`, {
                        content: delta
                    })
                    const editDone = new CustomEvent('DoneRichEdit', {
                        detail: {
                            id
                        }
                    });
                    document.dispatchEvent(editDone);
                } else {
                    const content = JSON.stringify(delta)
                    $(`input[name="${id}"]`).val(content)
                }
                editor.enable(false);
                $('button#edit', $context).removeClass('is-hidden')
                $('button#done', $context).addClass('is-hidden')
            })

            if (readOnly) {
                readText(content)
            } else {
                writeText(content)
            }

            if (window.Livewire) {
                Livewire.on(`LoadContent:${id}`, ({
                    content
                }) => {
                    editor.setContents(content)
                });
                Livewire.on(`DisposeContent:${id}`, () => {
                    editor.setContents(null)
                });
            }
        });
    </script>
</div>
