<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;
use Illuminate\Support\Collection;

class MediaSelect extends Component
{

  public string $name;
  public $options;
  public ?string $value = null;
  public string $id;
  public ?string $label = null;
  public ?string $placeholder = null;
  public ?string $hint = null;
  public ?string $defaultLabel = null;
  public $defaultSrc = null;
  public bool $preview;
  public int $containerWidth;
  public int $itemWidth;
  public bool $isRight = false;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param mixed $value
   * @param string|null $id
   * @param mixed $options
   * @param mixed $label
   * @param string $placeholder
   * @param bool $preview
   * @param int $containerWidth
   * @param int $itemWidth
   * @param bool $isRight
   * @param string|null $hint
   */
  public function __construct(
    string $name,
    ?string $value = null,
    ?string $id = null,
    mixed $options = [],
    mixed $label = null,
    string $placeholder = 'Select',
    bool $preview = true,
    int $containerWidth = 600,
    int $itemWidth = 200,
    bool $isRight = false,
    ?string $hint = null,
  ) {
    $this->name = $name;
    if ($options instanceof Collection) {
      $this->options = $options->toArray();
    } else {
      $this->options = $options;
    }
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));

    if ($value) {
      $selected = collect($options)->where('value', $value)->first();
      if ($selected) {
        $this->defaultLabel = $selected['label'];
        $this->defaultSrc = $selected['src'];
      } else {
        $this->defaultLabel = $placeholder;
        $this->defaultSrc = null;
      }
    } else {
      $this->defaultLabel = $placeholder;
      $this->defaultSrc = null;
    }
    $this->placeholder = $placeholder;
    $this->hint = $hint;
    $this->preview = $preview;
    $this->containerWidth = $containerWidth;
    $this->itemWidth = $itemWidth;
    $this->isRight = $isRight;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.media-select');
  }
}
