<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class FilePond extends Component
{

  /**
   * Constructor for the component.
   * 
   * This component is used to create a file upload field using FilePond.
   * It allows for easy file uploads with various options and features.
   * - Listens for the `ResetFile:id` event to reset the file input,
   * - Listens for the `SetTempFile:id <fileName, url>` event to set the file input,
   * - Dispatches the `CancelFile:id` event to cancel the file upload.
   * 
   * @param string $name  The name of the file field. It should match the name of the file field in the form.
   * @param string $id The unique id of the file field.
   * @param mixed $label The label for the file field. If not provided, it will be generated from the name.
   * @param array $options The options for the file field.
   */
  public function __construct(
    public string $name,
    public string $id,
    public mixed $label = null,
    public array $options = [],
  ) {
    if ($this->label !== false) {
      $this->label = $this->label ?? Str::headline($this->name);
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.file-pond');
  }
}
