<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Datepicker extends Component
{

  public string $name;

  /**
   * Type of picker - date | time | datetime 
   *
   * @var string
   */
  public string $type;
  public ?string $value = null;
  public string $id;
  public ?string $label = null;
  public ?string $hint = null;
  public ?string $minDate = null;
  public ?string $maxDate = null;
  public ?string $minTime = null;
  public ?string $maxTime = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param string $type - date | time | datetime
   * @param string|null $value
   * @param string|null $id
   * @param [type] $label
   * @param string|null $hint
   * @param array $dateLimits
   * @param array $timeLimits
   */
  public function __construct(
    string $name,
    string $type = 'date',
    ?string $value = null,
    ?string $id = null,
    mixed $label = null,
    ?string $hint = null,
    array $dateLimits = [],
    array $timeLimits = [],
  ) {
    $this->name = $name;
    $this->type = $type;
    $this->value = $value;
    $this->id = $id ? $id : Str::slug($name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->hint = $hint;
    if ($dateLimits) {
      $this->minDate = $dateLimits[0];
      $this->maxDate = $dateLimits[1];
    }
    if ($timeLimits) {
      $this->minTime = $timeLimits[0];
      $this->maxTime = $timeLimits[1];
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.datepicker');
  }
}
