<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Radio extends Component
{
  public string $name;
  public ?string $value = null;
  public ?string $id = null;
  public ?string $label = null;
  public $options;
  public string $classes;
  public ?string $hint = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param string|null $value
   * @param mixed $options
   * @param mixed $label
   * @param string $classes
   * @param string|null $hint
   */
  public function __construct(
    string $name,
    ?string $value = null,
    mixed $options = [],
    mixed $label = null,
    string $classes = '',
    ?string $hint = null
  ) {
    $this->name = $name;
    $this->value = $value;
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));

    //prepare options
    $radioOptions = [];
    foreach ($options as $value => $label) {
      $radioOptions[] = [
        'id' => Str::uuid(),
        'value' => $value,
        'label' => $label,
      ];
    }
    $this->options = $radioOptions;
    $this->classes = $classes;
    $this->hint = $hint;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.radio');
  }
}
