<div>
    <div class="field">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="control">
            @php
                $attr = $attributes->merge([
                    'id' => $id,
                    'class' => $class,
                    'placeholder' => $placeholder,
                ]);
                if ($attributes->has('disabled') && !$attributes->get('disabled')) {
                    $attr = $attr->except(['disabled']);
                }
                $attr = $attr->getAttributes();
            @endphp
            {{ html()->textarea($name, $value)->attributes($attr) }}
            {{-- <textarea name="{{ $name }}" id="{{ $id }}" class="{{ $class }}" placeholder="{{ $placeholder }}"
                {{ $attributes }}>{{ $value }}</textarea> --}}
        </div>
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
