<div>
    <div>
        <div class="field">
            @if ($label)
                <label class="label">{{ $label }}</label>
            @endif

            <div class="control" wire:ignore>
                <div id="{{ $id }}" class="range-slider {{ $class }}"
                    data-input-name="{{ $name }}" data-range="{{ $range ? 'true' : 'false' }}"
                    data-show-pips="{{ $showPips ? 'true' : 'false' }}">
                </div>
            </div>

            @if ($hint)
                <p class="help is-info" @style(['margin-top:60px' => $showPips])>{{ $hint }}</p>
            @endif
        </div>

        @error($name)
            <p class="help is-danger" @style(['margin-top:60px' => $showPips])>{{ $message }}</p>
        @enderror
    </div>

    <script type="module">
        // Initialize the slider when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            if (!window.RangeSelector) {
                console.error('RangeSelector: RangeSelector class is not defined');
                return;
            }

            const config = JSON.parse(@json($configJson));
            const options = JSON.parse(@json($optionsJson));

            if (window.rangeSelector_{{ $id }}) {
                window.rangeSelector_{{ $id }}.destroy();
            }

            // Create and store the slider instance globally for potential external access
            window.rangeSelector_{{ $id }} = new window.RangeSelector('{{ $id }}', config,
                options);
        });
    </script>
</div>
