<div>
    <div class="field">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <input type="hidden" name="{{ $name }}" value="{{ $value }}" id="{{ $id }}">
        <div @class(['dropdown is-hoverable', 'is-right' => $isRight]) id="dd-{{ $id }}">
            <div class="dropdown-trigger">
                <button type="button" class="button" aria-haspopup="true" aria-controls="dropdown-menu">
                    <span id="selected-{{ $id }}" data-default="{{ $placeholder }}"
                        style="overflow: hidden; text-overflow: ellipsis; max-width: 128px;">{{ $defaultLabel }}</span>
                    <span class="icon is-small">
                        <span class="material-symbols-outlined">
                            keyboard_arrow_down
                        </span>
                    </span>
                </button>
            </div>
            <div class="dropdown-menu" id="dropdown-menu" role="menu">
                <div class="dropdown-content is-flex is-flex-wrap-wrap" style="width: {{ $containerWidth }}px">
                    @if ($options)
                        @foreach ($options as $option)
                            <a href="#" class="dropdown-item p-2" data-value="{{ $option['value'] }}"
                                data-label="{{ $option['label'] }}" style="width: {{ $itemWidth }}px;">
                                <div class="is-flex is-align-items-center">
                                    <figure class="image is-48x48">
                                        <img src="{{ $option['src'] }}" alt="{{ $option['label'] }}"
                                            style="min-width: 48px">
                                    </figure>
                                    <span class="pl-2" style="white-space: initial">
                                        {{ $option['label'] }}
                                    </span>
                                </div>
                            </a>
                        @endforeach
                    @endif
                    <hr class="dropdown-divider my-1">
                    <a href="#" class="dropdown-item is-flex is-align-items-center clear">
                        <span class="icon">
                            <span class="material-symbols-outlined is-size-6">
                                close
                            </span>
                        </span>
                        <span>Clear</span>
                    </a>
                </div>
            </div>
        </div>
        @if ($preview)
            <div id="preview-{{ $id }}">
                @if ($defaultSrc)
                    <figure class="image is-48x48 ml-1 mt-2">
                        <img src="{{ $defaultSrc }}" style="min-width: 48px">
                    </figure>
                    <span class="icon ml-1 mt-2 is-hidden has-text-grey-light" style="min-height: 48px;">
                        <span class="material-symbols-outlined is-size-2">
                            image
                        </span>
                    </span>
                @else
                    <figure class="image is-48x48 ml-1 mt-2 is-hidden"></figure>
                    <span class="icon ml-1 mt-2 has-text-grey-ligh" style="min-height: 48px;">
                        <span class="material-symbols-outlined is-size-2">
                            image
                        </span>
                    </span>
                @endif
            </div>
        @endif
        @if (isset($hint))
            <p class="help is-info">{{ $hint }}</p>
        @endif
    </div>

    <script type="module">
        $(document).ready(function() {
            const $input = $('#{{ $id }}')
            const $preview = $('#preview-{{ $id }}')
            const $cont = $('#dd-{{ $id }}')
            const $inputLable = $('#selected-{{ $id }}')
            $('a.dropdown-item', $cont).on('click', function(event) {
                event.preventDefault();
                const $this = $(this)
                let value;
                const prevVal = $input.val()
                if ($this.hasClass('clear')) {
                    $inputLable.html($inputLable.data('default'))
                    $input.val("")
                    $('img', $preview).remove()
                    $('figure', $preview).addClass('is-hidden')
                    $('span', $preview).removeClass('is-hidden')
                } else {
                    value = $(this).data('value')
                    const label = $(this).data('label')
                    const src = $(this).data('src')
                    const selectedImage = $('img', $this).clone();
                    $inputLable.html(label)
                    $input.val(value)
                    $('img', $preview).remove()
                    $('figure', $preview).removeClass('is-hidden').append(selectedImage)
                    $('span', $preview).addClass('is-hidden')
                }
                if (prevVal != value) {
                    $input.trigger('change')
                }
            })
        });
    </script>
</div>
