<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Number extends Component
{
  public string $name;
  public ?string $value = null;
  public string $id;
  public ?string $label = null;
  public ?string $icon;
  public string $class;
  public ?string $hint = null;
  public ?string $placeholder = null;
  public ?string $addon = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param string|null $value
   * @param string|null $id
   * @param mixed $label
   * @param mixed $icon - true, false, '123'
   * @param string|null $placeholder
   * @param string|null $classes
   * @param string|null $hint
   * @param string|null $addon
   */
  public function __construct(
    string $name,
    ?string $value = null,
    ?string $id = null,
    $label = null,
    mixed $icon = '123',
    ?string $placeholder = null,
    ?string $classes = null,
    ?string $hint = null,
    ?string $addon = null
  ) {
    $this->name = $name;
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));

    // if icon is true, false, `true`, `false`, 0, 1, `0`, `1` consider it as a boolean
    if (in_array($icon, [true, 'true', 1, '1'], true)) {
      $this->icon = '123';
    } else if (in_array($icon, [false, 'false', 0, '0'], true)) {
      $this->icon = null;
    } else {
      $this->icon = $icon;
    }

    $this->class = "input has-text-right $classes";
    if ($this->label === false) {
      $this->placeholder = Str::title(str_replace('_', ' ', $name));
    }
    if ($placeholder) {
      $this->placeholder = $placeholder;
    }
    $this->hint = $hint;
    $this->addon = $addon;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.number');
  }
}
