<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;

class InputSwitch extends Component
{

  /**
   * Create a new component instance.
   * @param string $name Name of the input
   * @param mixed $id ID of the input
   * @param mixed $label Label of the input
   * @param mixed $hint Hint for the input
   */
  public function __construct(
    public string $name,
    public ?string $id = null,
    public ?string $label = null,
    public ?string $hint = null
  ) {
    $this->id = $id ?? str($name)->lower()->snake()->toString();
    $this->label = $label ?? str($name)->lower()->headline()->toString();
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.input-switch');
  }
}
