<?php

namespace V360\FormComponents;

use Illuminate\Support\ServiceProvider;
use V360\FormComponents\View\Components\ADatepicker;
use V360\FormComponents\View\Components\Amount;
use V360\FormComponents\View\Components\Autocomplete;
use V360\FormComponents\View\Components\Checkbox;
use V360\FormComponents\View\Components\Contactno;
use V360\FormComponents\View\Components\Datepicker;
use V360\FormComponents\View\Components\DynamicSelect;
use V360\FormComponents\View\Components\Email;
use V360\FormComponents\View\Components\File;
use V360\FormComponents\View\Components\FilePond;
use V360\FormComponents\View\Components\ImagePicker;
use V360\FormComponents\View\Components\InputSwitch;
use V360\FormComponents\View\Components\InputTags;
use V360\FormComponents\View\Components\Keyvalue;
use V360\FormComponents\View\Components\MediaSelect;
use V360\FormComponents\View\Components\Number;
use V360\FormComponents\View\Components\Password;
use V360\FormComponents\View\Components\Radio;
use V360\FormComponents\View\Components\ReCaptcha;
use V360\FormComponents\View\Components\RichText;
use V360\FormComponents\View\Components\Select;
use V360\FormComponents\View\Components\Table;
use V360\FormComponents\View\Components\Tags;
use V360\FormComponents\View\Components\Text;
use V360\FormComponents\View\Components\Textarea;

class FormComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {
    //merge config
    $this->mergeConfigFrom(__DIR__ . '/../config/config.php', 'vform');
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {

    if ($this->app->runningInConsole()) {
      // publish the configs
      $this->publishes([
        __DIR__ . '/../config/config.php' => config_path('vform.php'),
      ], 'config');

      // Publish view components
      $this->publishes([
        __DIR__ . '/../src/View/Components/' => app_path('View/Components/Vform'),
        __DIR__ . '/../resources/views/components/' => resource_path('views/components/vform'),
      ], 'vform');
    }

    // ... other things
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vform');

    //regiter components
    $this->loadViewComponentsAs('vform', [
      ADatepicker::class,
      Amount::class,
      Autocomplete::class,
      Checkbox::class,
      Contactno::class,
      Datepicker::class,
      DynamicSelect::class,
      Email::class,
      File::class,
      FilePond::class,
      ImagePicker::class,
      InputTags::class,
      InputSwitch::class,
      Keyvalue::class,
      MediaSelect::class,
      Number::class,
      Password::class,
      Radio::class,
      ReCaptcha::class,
      RichText::class,
      Select::class,
      Tags::class,
      Text::class,
      Textarea::class,
      Table::class,
    ]);
  }
}
