<div class="vform-tags">
    <div class="field" id="chips-{{ $id }}">
        @if ($label !== false)
            <label class="label">{{ $label }}</label>
        @endif
        <p class="control has-icons-left">
            <input class="input" type="text" placeholder="+ Enter" list="data-{{ $id }}"
                id="{{ $id }}" />
            <span class="icon is-small is-left">
                <span class="material-symbols-outlined">
                    label
                </span>
            </span>
        </p>
        <div class="control mt-3">
            <div class="tags">
                @if ($values)
                    @foreach ($values as $item)
                        @if ($keyValue)
                            @php
                                $item = $options[$item] ?? null;
                            @endphp
                        @endif
                        @if ($item)
                            <span class="tag is-primary is-light">
                                {{ $item }}
                                <button type="button" class="delete is-small" data-text="{{ $item }}"></button>
                            </span>
                        @endif
                    @endforeach
                @endif
            </div>
        </div>
        <div class="control">
            <input type="hidden" name="{{ $name }}" value="{{ json_encode($values) }}" class="tags-hidden">
            @if ($options)
                <datalist id="data-{{ $id }}">
                    @if ($keyValue)
                        @foreach ($options as $ok => $ov)
                            <option data-value="{{ $ok }}" value="{{ $ov }}" />
                        @endforeach
                    @else
                        @foreach ($options as $ov)
                            <option data-value="{{ $ov }}" value="{{ $ov }}" />
                        @endforeach
                    @endif
                </datalist>
            @endif
        </div>
        @if (isset($hint))
            <p class="help is-info">{{ $hint }}</p>
        @endif
        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>
    <script type="module">
        $(document).ready(function() {
            const name = '{{ $name }}'
            const $context = $('#chips-{{ $id }}')
            const $input = $('input[name={{ $name }}]', $context)
            const $handler = $('#{{ $id }}', $context)
            const $tags = $('div.tags', $context)
            let tags = [];
            const values = JSON.parse('<?= json_encode($values) ?>')
            const $form = $context.closest('form')
            const options = JSON.parse('<?= json_encode($options) ?>')
            const keyValue = Boolean('<?= $keyValue ?>')
            const $datalist = $('#data-{{ $id }}')
            if ($form.length > 0) {
                $form.on('keydown', function(event) {
                    if (event.keyCode == 13) {
                        event.preventDefault();
                        return false;
                    }
                })
            }

            if (keyValue) {
                values.forEach(element => {
                    tags.push(options[element])
                });
            }

            const removeValue = ($tag, text) => {
                $tag.remove()
                _.pull(tags, text)
                let value = text
                if (options && keyValue) {
                    value = _.findKey(options, (value, key) => value == text)
                }
                _.remove(values, (v) => v == value)
                if (tags.length == 0) {
                    $input.val('')
                } else {
                    $input.val(JSON.stringify(values))
                }
                // console.log(values);
            }

            //create html tag
            const createTag = (text) => {
                // Create the main tag element
                const $tag = $('<span>').addClass('tag is-primary is-light');
                $tag.text(text);
                const $delete = $('<button />', {
                    type: 'button'
                }).addClass('delete is-small');
                $tag.append($delete);
                $delete.on('click', function(e) {
                    removeValue($tag, text)
                })
                return $tag;
            }

            const addValue = () => {
                const tag = $handler.val()
                let value;
                //in case options are provided, 
                if (!options || (keyValue && _.keys(options).length == 0) || (!keyValue && options.length ==
                        0)) {
                    value = tag;
                } else {
                    //allowed values are from that only
                    const $selected = $datalist.find(`[value='${tag}']`)
                    value = $selected.data('value')
                    if (_.findKey(options, (value, key) => value == tag) === undefined) {
                        $handler.val('')
                        return;
                    }
                }
                if (_.indexOf(tags, tag) == -1) {
                    tags.push(tag)
                    values.push(value)
                    createTag(tag).appendTo($tags)
                }
                $input.val(JSON.stringify(values))
                $handler.val('')
                console.log(values);
            }

            $handler.on('keydown', function(e) {
                if (event.keyCode == 13) {
                    addValue(e)
                }
            })
            $handler.on('change', addValue)

            $('button.delete', $context).on('click', function() {
                removeValue($(this).parent(), $(this).data('text'))
            })
        });
    </script>
</div>
