<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;

class ReCaptcha extends Component
{

  /**
   * Version of reCaptcha 
   *
   * @var string
   */
  public string $version;

  /**
   * Create a new component instance.
   *
   * @param string $version
   */
  public function __construct($version = 'v3')
  {
    //
    $this->version = $version;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.re-captcha');
  }
}
