<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class InputSwitch extends Component
{

  /**
   * The unique ID of the input switch.
   * @var string
   */
  public string $id;

  /**
   * Create a new component instance.
   * @param string $name Name of the input
   * @param string $label Label of the input
   * @param string $color Color of the input switch
   * @param mixed $hint Hint for the input
   */
  public function __construct(
    public string $name,
    public string $label,
    public string $color = 'info',
    public ?string $hint = null
  ) {
    $this->id = Str::uuid();
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.input-switch');
  }
}
