<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class ImagePicker extends Component
{
  public string $name;
  public ?string $src;
  public string $id;
  public int $rotate;
  public bool $controls;
  public bool $isCapture;
  public ?float $aspectRatio;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param int $rotate - rotation in degrees, default is 10
   * @param bool $controls - show controls for rotation and capture, default is true
   * @param bool $isCapture - if true, allows capturing image from camera, default is false
   * @param string|null $src - source URL for the image, default is null
   * @param float|null $aspectRatio - aspect ratio of the image, default is null
   */
  public function __construct(
    string $name,
    int $rotate = 10,
    bool $controls = true,
    bool $isCapture = false,
    ?string $src = null,
    ?float $aspectRatio = null
  ) {
    //
    $this->name = $name;
    $this->src = $src;
    $this->id = Str::uuid();
    $this->rotate = $rotate;
    $this->controls = $controls;
    $this->isCapture = $isCapture;
    $this->aspectRatio = $aspectRatio;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\Contracts\View\View|\Closure|string
   */
  public function render()
  {
    return view('vform::components.image-picker');
  }
}
