<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Amount extends Component
{
  public string $name;
  public string $icon;
  public ?string $value = null;
  public string $id;
  public ?string $label = null;
  public string $class;
  public ?string $hint = null;
  public ?string $placeholder = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param string $currency - rupee | dollar | euro | pound
   * @param string|null $value
   * @param string|null $id
   * @param mixed $label
   * @param string|null $placeholder
   * @param string|null $classes
   * @param string|null $hint
   */
  public function __construct(
    string $name,
    string $currency = "rupee",
    ?string $value = null,
    ?string $id = null,
    mixed $label = null,
    ?string $placeholder = null,
    ?string $classes = null,
    ?string $hint = null
  ) {
    $this->name = $name;
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->class = "input has-text-right $classes";
    if ($this->label === false) {
      $this->placeholder = Str::title(str_replace('_', ' ', $name));
    }
    if ($placeholder) {
      $this->placeholder = $placeholder;
    }
    $this->hint = $hint;

    switch ($currency) {
      case 'rupee':
        $this->icon = 'currency_rupee';
        break;
      case 'dollar':
        $this->icon = 'attach_money';
        break;
      case 'euro':
        $this->icon = 'euro';
        break;
      case 'pound':
        $this->icon = 'currency_pound';
        break;
      default:
        $this->icon = 'attach_money';
        break;
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.amount');
  }
}
