<div>
    @if ($label)
        <label for="{{ $id }}" class="label">{{ $label }}</label>
    @endif
    <div class="field {{ $domain ? 'has-addons' : '' }}">
        <div class="control has-icons-left is-expanded">
            @php
                $attr = $attributes->merge([
                    'id' => $id,
                    'class' => $class,
                    'placeholder' => $placeholder,
                ]);
                if ($attributes->has('disabled') && !$attributes->get('disabled')) {
                    $attr = $attr->except(['disabled']);
                }
                $attr = $attr->getAttributes();
            @endphp
            {{ html()->email($name, $value)->attributes($attr) }}
            <span class="icon is-small is-left">
                <span class="material-symbols-outlined is-size-6">
                    mail
                </span>
            </span>
        </div>
        @if ($domain)
            <p class="control">
                <a class="button is-static">
                    {{ $domain }}
                </a>
            </p>
        @endif
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
