<div class="field">
    @if ($label)
        <label for="{{ $id }}" class="label">{{ $label }}</label>
    @endif
    <div class="control is-expanded {{ $icon ? 'has-icons-left' : '' }}">
        <div class="select is-fullwidth {{ $multiple ? 'is-multiple' : '' }}">
            <select {{ $multiple ? 'multiple' : '' }} name="{{ $name }}" id="{{ $id }}"
                {{ $attributes }}>
                @if ($placeholder)
                    <option value="">{{ $placeholder }}</option>
                @endif
                @if ($options)
                    @foreach ($options as $key => $option)
                        @if (is_array($option))
                            <optgroup label="{{ $key }}">
                                @foreach ($option as $key => $opt)
                                    @if (is_null($value))
                                        @if ($key === $value)
                                            <option value="{{ $key }}" selected>{{ $opt }}</option>
                                        @else
                                            <option value="{{ $key }}">{{ $opt }}</option>
                                        @endif
                                    @else
                                        @if ($key == $value)
                                            <option value="{{ $key }}" selected>{{ $opt }}</option>
                                        @else
                                            <option value="{{ $key }}">{{ $opt }}</option>
                                        @endif
                                    @endif
                                @endforeach
                            </optgroup>
                        @else
                            @if (is_null($value))
                                @if ($key === $value)
                                    <option value="{{ $key }}" selected>{{ $option }}</option>
                                @else
                                    <option value="{{ $key }}">{{ $option }}</option>
                                @endif
                            @else
                                @if ($key == $value)
                                    <option value="{{ $key }}" selected>{{ $option }}</option>
                                @else
                                    <option value="{{ $key }}">{{ $option }}</option>
                                @endif
                            @endif
                        @endif
                    @endforeach
                @endif
            </select>
        </div>
        @if ($icon)
            <div class="icon is-small is-left">
                <span class="material-symbols-outlined is-size-6">
                    {{ $icon }}
                </span>
            </div>
        @endif
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
