<div id="input-fp-{{ $id }}">
    <div class="field">
        @if ($label)
            <span class="label">{{ $label }}</span>
        @endif
        <div class="control" wire:ignore>
            <input type="file" class="filepond" name="filepond" id="fp-{{ $id }}" {{ $attributes }}>
        </div>
        @isset($slot)
            {{ $slot }}
        @endisset
        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
        <div>
            <progress class="progress is-small is-warning is-hidden" value="0" max="100"></progress>
        </div>
    </div>
    @script
        <script type="module">
            $(document).ready(function() {
                const id = '{{ $id }}';
                const name = '{{ $name }}';
                const options = @json($options);
                const $context = $(`#input-fp-${id}`);
                const fileInput = $('input[name=filepond]', $context).get(0);
                const $progress = $('progress', $context);

                const onUploadDone = (uploadedFilename) => {
                    $progress.addClass('is-hidden');
                    const customEvent = new CustomEvent('FileUploadDoneViaFilepond', {
                        detail: {
                            id: id,
                            name: name,
                            filename: uploadedFilename
                        }
                    });
                    document.dispatchEvent(customEvent);
                }

                const onUploadStarted = () => {
                    $progress.removeClass('is-hidden');
                    $progress.attr('value', 0);
                    const customEvent = new CustomEvent('FileUploadStartedViaFilepond', {
                        detail: {
                            id: id,
                            name: name,
                        }
                    });
                    document.dispatchEvent(customEvent);
                }
                const uploadFile = (file) => {
                    onUploadStarted();
                    const onSuccess = (uploadedFilename) => {
                        console.debug('File uploaded', uploadedFilename);
                        onUploadDone(uploadedFilename);
                    };
                    const onError = () => {
                        console.error('File upload error');
                    };
                    const onProgress = (event) => {
                        $progress.attr('value', event.detail.progress);
                        console.debug('File upload progress', event.detail.progress);
                    }
                    const onCancelled = () => {
                        console.debug('File upload cancelled');
                    }
                    $wire.upload(name, file, onSuccess, onError, onProgress, onCancelled);
                }
                const initFilePond = () => {
                    const pond = FilePond.create(fileInput);
                    pond.setOptions(options);
                    pond.on('addfile', (error, file) => {
                        if (error) {
                            console.error('File add error', error);
                            return;
                        }
                        uploadFile(file.file);
                    });
                    pond.on('removefile', (error, file) => {
                        console.debug('File removed', id);
                        $wire.dispatch(`CancelFile:${id}`);
                    });
                }
                initFilePond();
                $wire.on(`ResetFile:${id}`, () => {
                    console.debug('Resetting file', id);
                    const pond = FilePond.find(fileInput);
                    if (pond) {
                        pond.removeFiles();
                    }
                });
                $wire.on(`SetTempFile:${id}`, async ({
                    fileName,
                    url
                }) => {
                    try {
                        const pond = FilePond.find(fileInput);
                        if (pond) {
                            pond.addFile(url);
                        }
                    } catch (err) {
                        console.error('Error setting temp file', err);
                    }
                });
            });
        </script>
    @endscript
</div>
