<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;
use Illuminate\Support\Collection;

class Tags extends Component
{
  /**
   * Create a new component instance.

   * @param string $name
   * @param mixed $label
   * @param string|null $id
   * @param mixed $values
   * @param array $options
   * @param boolean $keyValue
   * @param string|null $placeholder
   * @param string|null $hint
   */
  public function __construct(
    public string $name,
    public mixed $label = null,
    public ?string $id = null,
    public mixed $values = [],
    public array|Collection $options = [],
    public bool $keyValue = true,
    public ?string $placeholder = null,
    public ?string $hint = null,
  ) {
    $this->id = $id ?? Str::uuid();
    $this->label = $label !== false ? ($label ?? Str::headline($name)) : false;
    if (is_string($values)) {
      $this->values = json_decode($values);
    } else if (!is_array($values)) {
      $this->values = $this->values->toArray();
    }
    if (is_array($options) && !$options) {
      $this->keyValue = false;
    } else if ($options && !is_array($options) && $options->isEmpty()) {
      $this->keyValue = false;
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.tags');
  }
}
