<?php

namespace V360\FormComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Illuminate\View\Component;

class InputTags extends Component
{
  /**
   * Contructor
   * 
   * @dispatches InputTagsChanged on change of value
   * @listens for InitInputTags:name to set initial value
   * @listens for ResetInputTags:name to reset value
   * 
   * @param string $name
   * @param \mixed|null $label
   * @param mixed $id
   * @param \mixed $value
   * @param array|\Illuminate\Support\Collection $options
   * @param bool $keyValue
   */
  public function __construct(
    public string $name,
    public mixed $label = null,
    public ?string $id = null,
    public mixed $value = [],
    public array|Collection $options = [],
    public bool $keyValue = false,
  ) {
    //
    $this->id = $id ?? Str::uuid();
    $this->label = $label !== false ? ($label ?? Str::headline($name)) : false;
    if (is_string($value)) {
      $this->value = json_decode($value);
    } else if (!is_array($value)) {
      $this->value = $this->value->toArray();
    }
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vform::components.input-tags');
  }
}
