<div>
    @if ($label)
        <label for="{{ $id }}" class="label">{{ $label }}</label>
    @endif
    <div class="field {{ $addon ? 'has-addons' : '' }}">
        <div @class(['control is-expanded', 'has-icons-left' => $icon])>
            @php
                $attr = $attributes->merge([
                    'id' => $id,
                    'class' => $class,
                    'placeholder' => $placeholder,
                ]);
                if ($attributes->has('disabled') && !$attributes->get('disabled')) {
                    $attr = $attr->except(['disabled']);
                }
                $attr = $attr->getAttributes();
            @endphp
            {{ html()->input('number', $name, $value)->attributes($attr) }}
            @if ($icon)
                <span class="icon is-small is-left">
                    @if (Str::startsWith($icon, 'fa'))
                        <i class="{{ $icon }}"></i>
                    @else
                        <span class="material-symbols-outlined is-size-6">
                            {{ $icon }}
                        </span>
                    @endif
                </span>
            @endif
        </div>
        @if ($addon)
            <p class="control">
                <a class="button is-static">
                    {{ $addon }}
                </a>
            </p>
        @endif
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
