<div>
    <div class="field">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="control has-icons-left is-expanded">
            <div class="select is-fullwidth">
                <select name="{{ $name }}" id="{{ $id }}" class="{{ $class }}"
                    {{ $attributes }}>
                    <option value="">{{ $placeholder }}</option>
                    @if ($options)
                        @foreach ($options as $key => $option)
                            @if (is_array($option))
                                <optgroup label="{{ $key }}">
                                    @foreach ($option as $key => $opt)
                                        @if ($key == $value)
                                            <option value="{{ $key }}" selected>{{ $opt }}</option>
                                        @else
                                            <option value="{{ $key }}">{{ $opt }}</option>
                                        @endif
                                    @endforeach
                                </optgroup>
                            @else
                                @if ($key == $value)
                                    <option value="{{ $key }}" selected>{{ $option }}</option>
                                @else
                                    <option value="{{ $key }}">{{ $option }}</option>
                                @endif
                            @endif
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="icon is-small is-left">
                <span class="material-symbols-outlined is-size-6">
                    {{ $icon }}
                </span>
            </div>
        </div>
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
    <script type="module">
        $(document).ready(function() {
            const $parent = $('#{{ $id }}');
            const $child = $('#{{ $child }}');

            $parent.change(function() {
                const parentId = $(this).val();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('input[name=_token]').val()
                    }
                });

                //clear all options except first
                $child.find('option:not(:first)').remove();

                $.ajax({
                    url: "{{ $route }}",
                    type: "GET",
                    data: {
                        parent_id: parentId
                    },
                    dataType: "JSON",
                    success: function(response) {
                        const children = response.children;
                        $.each(children, (key, value) => {
                            $child.append($('<option></option>').attr('value', key)
                                .text(value));
                        });
                        $child.focus();
                    },
                    error: function(jq, status, error) {
                        showAjaxErrors(jq);
                    }
                });
            });
        });
    </script>
</div>
