<div>
    <div class="field {{ $margin }}">
        @if (!$multiple)
            <div class="control">
                @if ($value == true)
                    <input type="checkbox" name="{{ $name }}" id="{{ $id }}" checked
                        class="{{ $class }}" {{ $attributes }}>
                @else
                    <input type="checkbox" name="{{ $name }}" id="{{ $id }}" class="{{ $class }}"
                        {{ $attributes }}>
                @endif
                <label for="{{ $id }}" class="{{ $label ? '' : 'pl-0' }}">
                    {{ $label }}
                </label>
            </div>
        @else
            @if ($label)
                <label for="{{ $id }}" class="label">{{ $label }}</label>
            @endif
            <div class="pt-2">
                @if ($options)
                    @foreach ($options as $option)
                        <div class="control mt-2">
                            <input type="checkbox" name="{{ $name }}" id="{{ $option['id'] }}"
                                value="{{ $option['value'] }}" class="{{ $class }}"
                                {{ $option['checked'] ? 'checked' : '' }} {{ $attributes }}>
                            <label for="{{ $option['id'] }}">{{ $option['label'] }}</label>
                        </div>
                    @endforeach
                @endif
            </div>
        @endif
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
