<div>
    @if ($label)
        <label for="{{ $id }}" class="label">{{ $label }}</label>
    @endif
    <div class="field mb-0">
        <div class="control">
            <input type="text" id="{{ $id }}" name="{{ $name }}" value="{{ $value }}"
                {{ $attributes }} class="input f-{{ $type }} flatpickr" autocomplete="off" />
        </div>
        @if (isset($hint))
            <p class="help is-info">{{ $hint }}</p>
        @endif
        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>
    @script
        <script type="module">
            $(document).ready(function() {
                const type = "{{ $type }}"
                const $input = $('#{{ $id }}')

                function initFlatpickr(type, $input) {
                    let options;
                    let minDate, maxDate, minTime, maxTime;
                    switch (type) {
                        case "datetime":
                            options = {
                                enableTime: true,
                                dateFormat: "Y-m-d H:i",
                            }
                            minDate = '{{ $minDate }}'
                            if (minDate) {
                                options['minDate'] = minDate
                            }
                            maxDate = '{{ $maxDate }}'
                            if (maxDate) {
                                options['maxDate'] = maxDate
                            }
                            minTime = '{{ $minTime }}'
                            if (minTime) {
                                options['minTime'] = minTime
                            }
                            maxTime = '{{ $maxTime }}'
                            if (maxTime) {
                                options['maxTime'] = maxTime
                            }
                            break;
                        case 'time':
                            options = {
                                enableTime: true,
                                noCalendar: true,
                                dateFormat: "H:i",
                                time_24hr: true
                            }
                            minTime = '{{ $minTime }}'
                            if (minTime) {
                                options['minTime'] = minTime
                            }
                            maxTime = '{{ $maxTime }}'
                            if (maxTime) {
                                options['maxTime'] = maxTime
                            }
                            break;
                        default:
                            options = {
                                dateFormat: "Y-m-d"
                            }
                            minDate = '{{ $minDate }}'
                            if (minDate) {
                                options['minDate'] = minDate
                            }
                            maxDate = '{{ $maxDate }}'
                            if (maxDate) {
                                options['maxDate'] = maxDate
                            }
                            break;
                    }
                    if (window.flatpickr) {
                        window.flatpickr($input.get(0), options);
                    }
                }

                initFlatpickr(type, $input)
            });
        </script>
    @endscript
</div>
