<?php

namespace V360\FormComponents\Rules;

use GuzzleHttp\Client;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Log;

class ReCaptcha implements Rule
{

  /**
   * Error message
   *
   * @var string
   */
  public string $error;

  /**
   * Create a new rule instance.
   *
   * @return void
   */
  public function __construct()
  {
    //
    $this->error = 'Please ensure that you are a human!';
  }

  /**
   * Determine if the validation rule passes.
   *
   * @param  string  $attribute
   * @param  mixed  $value
   * @return bool
   */
  public function passes($attribute, $value)
  {
    try {
      //get version
      $version = config('vform.recaptcha.version');

      switch ($version) {
        case 'v3':
          $secret = config('vform.recaptcha.secret');
          $client = new Client();

          $response = $client->post(
            'https://www.google.com/recaptcha/api/siteverify',
            [
              'form_params' =>
              [
                'secret' => $secret,
                'response' => $value,
              ],
            ]
          );

          $body = json_decode((string) $response->getBody());
          return $body->success;
        case 've':
          $apiKey = config('vform.recaptcha.ve.apikey');
          $projectId = config('vform.recaptcha.ve.project_id');
          $siteKey = config('vform.recaptcha.ve.key');
          $action = config('vform.recaptcha.ve.action');

          $client = new Client();
          $url = "https://recaptchaenterprise.googleapis.com/v1/projects/{$projectId}/assessments?key={$apiKey}";
          $response = $client->post(
            $url,
            [
              "json" => [
                "event" => [
                  "token" => $value,
                  "siteKey" => $siteKey,
                  "expectedAction" => $action
                ]
              ]
            ]
          );
          //get resposne
          $body = json_decode((string) $response->getBody());
          return $body->tokenProperties->valid;
        default:
          $this->error = 'ReCaptcha Validation Configuration Error';
          return false;
      }
    } catch (\Throwable $th) {
      $this->error = 'ReCaptcha Validation Error';
      Log::error("ReCaptachError", [$th->getMessage()]);
      return false;
    }
  }

  /**
   * Get the validation error message.
   *
   * @return string
   */
  public function message()
  {
    return $this->error;
  }
}
