<div>
    <div>
        <div class="field">
            @if ($label)
                <label class="label">{{ $label }}</label>
            @endif

            <div class="control px-4" wire:ignore>
                <div id="{{ $id }}" class="range-slider {{ $class }}"
                    data-input-name="{{ $name }}" data-range="{{ $range ? 'true' : 'false' }}"
                    data-show-pips="{{ $showPips ? 'true' : 'false' }}"
                    data-show-input="{{ $showInput ? 'true' : 'false' }}" data-step="{{ $step }}"
                    @style(['margin-bottom:60px' => $showPips])>
                </div>

                @if ($showInput)
                    <div class="is-flex is-justify-content-space-between is-align-content-center mt-5">
                        <div class="field">
                            <div class="control has-icons-left">
                                <input type="number" id="{{ $id }}_start_input" class="input range-input"
                                    min="{{ $min }}" max="{{ $max }}" value="{{ $start }}"
                                    placeholder="Start">
                                <span class="icon is-small is-left">
                                    <span class="material-symbols-outlined">
                                        first_page
                                    </span>
                                </span>
                            </div>
                        </div>
                        @if ($range)
                            <div class="field">
                                <div class="control has-icons-right">
                                    <input type="number" id="{{ $id }}_end_input"
                                        class="input range-input has-text-right" min="{{ $min }}"
                                        max="{{ $max }}" value="{{ $end }}" placeholder="End">
                                    <span class="icon is-small is-right">
                                        <span class="material-symbols-outlined">
                                            last_page
                                        </span>
                                    </span>
                                </div>
                            </div>
                        @endif
                    </div>
                @endif
            </div>

            @if ($hint)
                <p class="help is-info">{{ $hint }}</p>
            @endif

            @error($name)
                <p class="help is-danger">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <script type="module">
        // Initialize the slider when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            if (!window.RangeSelector) {
                console.error('RangeSelector: RangeSelector class is not defined');
                return;
            }

            const config = JSON.parse(@json($configJson));
            const options = JSON.parse(@json($optionsJson));
            const dispatchGenericEvent = {{ $dispatchGenericEvent ? 'true' : 'false' }};
            const debug = false;

            if (window.rangeSelector_{{ $id }}) {
                window.rangeSelector_{{ $id }}.destroy();
            }

            // Create and store the slider instance globally for potential external access
            window.rangeSelector_{{ $id }} = window.RangeSelector.create('{{ $id }}', config,
                options, dispatchGenericEvent, debug);
        });
    </script>
</div>
