<div>
    <div id="ic-panel-{{ $id }}">
        <div class="">
            <img id="image-{{ $id }}" src="{{ $src }}" alt=""
                style="display: block; max-width: 100%;">
            <input type="hidden" name="{{ $name }}_parameters" id="parameters-{{ $id }}">
        </div>
        <div class="columns">
            <div class="column is-6">
                <div class="img-preview is-clipped panel my-3" style="min-height:144px;"></div>
            </div>
        </div>
        <div class="columns">
            <div class="column is-6 is-flex is-align-items-center is-justify-content-space-between">
                <div class="field mb-0">
                    <div class="file has-name">
                        <label class="file-label">
                            <input class="file-input" type="file" name="{{ $name }}"
                                id="select-{{ $id }}" tooltip="Pick an Image">
                            <span class="file-cta">
                                <span class="file-icon">
                                    <i class="fas fa-upload"></i>
                                </span>
                                <span class="file-label">
                                    Pick
                                </span>
                            </span>
                            <span class="file-name"></span>
                        </label>
                    </div>
                </div>
                @if ($isCapture)
                    <span class="icon">
                        <i class="fas fa-exchange-alt"></i>
                    </span>
                    <div class="field">
                        <input type="hidden" name="raw_{{ $name }}" id="raw-{{ $id }}" />
                        <button class="button is-success is-webcam-capture" type="button"
                            data-target="wc-container-{{ $id }}">
                            <span class="icon">
                                <i class="fas fa-camera"></i>
                            </span>
                        </button>
                    </div>
                @endif
            </div>
            @if ($controls)
                <div class="column">
                    <div class="columns">
                        <div class="column">
                            <div class="buttons has-addons">
                                <button class="button flip-y is-info is-outlined" type="button"
                                    data-tooltip="Flip Verticle" disabled>
                                    <i class="fas fa-arrows-alt-v"></i>
                                </button>
                                <button class="button flip-x is-info is-outlined" type="button"
                                    data-tooltip="Flip Horizontal" disabled>
                                    <i class="fas fa-arrows-alt-h"></i>
                                </button>
                            </div>
                        </div>
                        <div class="column">
                            <div class="buttons has-addons">
                                <button class="button rotate-r is-success is-outlined" type="button"
                                    data-tooltip="Rotate Clockwise" disabled>
                                    <i class="fas fa-redo"></i>
                                </button>
                                <button class="button rotate-l is-success is-outlined" type="button"
                                    data-tooltip="Rotate Anti-clockwise" disabled>
                                    <i class="fas fa-undo"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    <div class="modal-container">
        <div class="modal" id="wc-container-{{ $id }}">
            <div class="modal-background"></div>
            <div class="modal-content is-modal-medium" style="height: 580px; width:700px;">
                <div class="camera" style="width: 640px; height:480px; margin:auto"></div>
                <div class="has-text-centered mt-3">
                    <button class="button is-warning capture" type="button">
                        <span class="icon">
                            <span class="material-symbols-outlined is-size-6">
                                photo_camera
                            </span>
                        </span>
                        <span>Capture</span>
                    </button>
                </div>
                <button class="modal-close is-large" aria-label="close" type="button"></button>
            </div>
        </div>
    </div>
    <script type="module">
        $(document).ready(function() {

            //check browser compatibility
            let $context = $('#ic-panel-{{ $id }}')
            const rotateAngle = Number('{{ $rotate }}')
            const aspectRatio = Number('{{ $aspectRatio }}')

            let uploadedImageURL, uploadedImageType, uploadedImageName;
            let cropper;
            let options = {
                preview: '#ic-panel-{{ $id }} .img-preview',
                ready: function(e) {
                    //console.log(e.type);
                    $('.button', $context).removeAttr('disabled')
                },
                crop: function(e) {
                    let data = e.detail;
                    const parameters = document.getElementById('parameters-{{ $id }}')
                    parameters.value = JSON.stringify(e.detail)
                },
            }
            if (aspectRatio > 0) {
                options['aspectRatio'] = aspectRatio
            }

            //image container
            let image = document.getElementById('image-{{ $id }}');

            //image selector
            const selectImage = document.getElementById('select-{{ $id }}');

            if (window.URL || window.webkitURL) {
                selectImage.onchange = function() {
                    var files = this.files;
                    var file;

                    if (files && files.length) {
                        file = files[0];

                        if (/^image\/\w+/.test(file.type)) {
                            uploadedImageType = file.type;
                            uploadedImageName = file.name;

                            if (uploadedImageURL) {
                                URL.revokeObjectURL(uploadedImageURL);
                            }

                            image.src = uploadedImageURL = URL.createObjectURL(file);

                            if (cropper) {
                                cropper.destroy();
                            }

                            //initialize cropper object
                            cropper = new Cropper(image, options);
                            //selectImage.value = null;
                        } else {
                            window.alert('Please choose an image file.');
                        }
                    }
                };
            } else {
                selectImage.disabled = true;
                selectImage.parentNode.className += ' disabled';
            }

            $('.flip-x', $context).click(function() {
                const scale = cropper.getData().scaleX
                cropper.scaleX(-scale)
            })
            $('.flip-y', $context).click(function() {
                const scale = cropper.getData().scaleY
                cropper.scaleY(-scale)
            })
            $('.rotate-r', $context).click(function() {
                cropper.rotate(rotateAngle)
            })
            $('.rotate-l', $context).click(function() {
                cropper.rotate(-rotateAngle)
            })

            /*
             * Webcam JS
             */
            const rawImage = document.getElementById('raw-{{ $id }}');
            $('button.is-webcam-capture', $context).on('click', function() {
                const $this = $(this);
                const target = $this.data('target');
                const $modal = $(`#${target}`);
                $modal.addClass('is-active');
                const $camera = $('div.camera', $modal)

                //initialize webcam
                Webcam.set({
                    width: 640,
                    height: 480,
                    upload_name: "{{ $name }}"
                })
                Webcam.attach($camera.get(0))

                $('button.capture', $modal).on('click', function() {
                    Webcam.snap(function(data) {
                        image.src = data
                        const raw_image_data = data.replace(/^data\:image\/\w+\;base64\,/,
                            '');
                        rawImage.value = raw_image_data;
                    })
                    //initialize cropper object
                    if (cropper) {
                        cropper.destroy();
                    }
                    cropper = new Cropper(image, options);
                    $('button.modal-close', $modal).trigger('click')
                })

                $('button.modal-close', $modal).on('click', function() {
                    Webcam.reset();
                })
            })

        });
    </script>
</div>
