<div class="vform-ac">
    <div class="field" id="ac-{{ $id }}">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="control has-icons-left" wire:ignore>
            <input type="text" class="input" id="handler-{{ $id }}" list="data-{{ $id }}"
                placeholder="{{ $placeholder }}"
                @if ($value && isset($options[$value])) value="{{ $options[$value] }}" @endif {{ $attributes }} />
            <span class="icon is-small is-left">
                <span class="material-symbols-outlined">
                    search
                </span>
            </span>
            <input type="hidden" name="{{ $name }}" value="{{ $value }}" id="{{ $id }}"
                class="ac-hidden">
            <datalist id="data-{{ $id }}">
                @foreach ($options ?? [] as $ok => $ol)
                    <option data-value="{{ $ok }}" value="{{ $ol }}" />
                @endforeach
            </datalist>
        </div>
        @if (isset($hint))
            <p class="help is-info">{{ $hint }}</p>
        @endif
        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>
    <script type="module">
        $(document).ready(function() {
            const id = '{{ $id }}'
            const name = '{{ $name }}'
            const startSearch = Boolean('{{ $startSearch ?? false }}')
            const isLivewire = Boolean('{{ $isLivewire ?? false }}')

            const handleStartSearch = ($datalist, $handler) => {
                // Dynamically build allOptions from datalist options
                const allOptions = [];
                $('option', $datalist).each(function() {
                    allOptions.push({
                        value: $(this).val(),
                        dataValue: $(this).data('value'),
                    });
                });

                $handler.on("input", function() {
                    const query = $handler.val().toLowerCase();
                    $datalist.empty();
                    // Filter suggestions based on the value that starts with the query
                    const filteredSuggestions = allOptions.filter(item =>
                        item.value.toLowerCase().startsWith(query)
                    );

                    // Add filtered suggestions to the datalist
                    filteredSuggestions.forEach(item => {
                        $datalist.append(
                            `<option value="${item.value}" data-value="${item.dataValue}">`
                        );
                    });
                });
            }

            const init = (value, label) => {
                const $context = $(`#ac-${id}`)
                const $handler = $(`#handler-${id}`, $context)
                const $datalist = $(`#data-${id}`, $context)
                const $input = $(`input[name=${name}]`, $context)
                if (value) {
                    $input.val(value)
                }
                if (label) {
                    $handler.val(label)
                }
                if (startSearch) {
                    handleStartSearch($datalist, $handler);
                }
                $handler.on('change', function(e) {
                    let value = e.target.value
                    const $selected = $datalist.find(`[value='${value}']`)
                    if ($selected && $selected.length > 0) {
                        let id = $selected.data('value')
                        $input.val(id)
                    } else {
                        e.target.value = ''
                        $input.val('')
                    }
                    $input.trigger('change')
                    if (isLivewire && window.Livewire) {
                        let value;
                        if ($input.val() == '') {
                            value = null;
                        } else {
                            value = $input.val()
                        }
                        window.Livewire.dispatch(`AutoCompleteSet:${name}`, {
                            value
                        })
                    }
                })
            }

            const reset = () => {
                const $context = $(`#ac-${id}`)
                const $handler = $(`#handler-${id}`, $context)
                const $input = $(`input[name=${name}]`, $context)
                $handler.val('')
                $input.val('')
            }

            const setItems = (items) => {
                const $context = $(`#ac-${id}`)
                const $handler = $(`#handler-${id}`, $context)
                const $datalist = $(`#data-${id}`, $context)
                const $input = $(`input[name=${name}]`, $context)
                $handler.val('');
                $input.val('');
                $datalist.empty();
                for (const ok in items) {
                    if (Object.prototype.hasOwnProperty.call(items, ok)) {
                        const ol = items[ok];
                        $datalist.append(`<option data-value="${ok}" value="${ol}" />`);
                    }
                }
                if (startSearch) {
                    handleStartSearch($datalist, $handler);
                }
            }
            init();

            if (window.Livewire) {
                window.Livewire.on(`AutoCompleteInit:${name}`, ({
                    value,
                    label
                }) => {
                    init(value, label)
                })
                window.Livewire.on('AutoCompleteReset', ({
                    autoFields
                }) => {
                    if (autoFields.includes(name)) {
                        reset()
                    }
                })
                window.Livewire.on(`AutoCompleteItems:${name}`, ({
                    items
                }) => {
                    setItems(items)
                })
            }
        });
    </script>
</div>
