<div>
    <div class="field">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="pt-2">
            @if ($options)
                @foreach ($options as $option)
                    @php
                        $checked = $value == $option['value'];
                    @endphp
                    <div class="control mt-2">
                        <input type="radio" name="{{ $name }}" id="{{ $option['id'] }}"
                            value="{{ $option['value'] }}" class="is-checkradio {{ $classes }}"
                            {{ $checked ? 'checked' : '' }} {{ $attributes }}>
                        <label for="{{ $option['id'] }}">{{ $option['label'] }}</label>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
