<div wire:ignore>
    <div class="field" id="input-tags-{{ $id }}">
        @if ($label !== false)
            <label class="label">{{ $label }}</label>
        @endif
        <p class="control has-icons-left">
            <input class="input" type="text" placeholder="+ Enter" list="data-{{ $id }}"
                id="{{ $id }}" />
            <span class="icon is-small is-left">
                <span class="material-symbols-outlined">
                    label
                </span>
            </span>
        </p>
        <div class="control mt-3">
            <div class="tags">
                @if ($value)
                    @foreach ($value as $item)
                        <span class="tag is-primary">
                            {{ $item }}
                            <button type="button" class="delete is-small" data-text="{{ $item }}"></button>
                        </span>
                    @endforeach
                @endif
            </div>
        </div>
        <div class="control">
            <input type="hidden" name="{{ $name }}" value="{{ json_encode($value) }}">
            @if ($options)
                <datalist id="data-{{ $id }}">
                    @if ($keyValue)
                        @foreach ($options as $ok => $ov)
                            <option data-value="{{ $ok }}" value="{{ $ov }}" />
                        @endforeach
                    @else
                        @foreach ($options as $ov)
                            <option data-value="{{ $ov }}" value="{{ $ov }}" />
                        @endforeach
                    @endif
                </datalist>
            @endif
        </div>
    </div>
    @script
        <script type="module">
            $(document).ready(function() {
                const name = '{{ $name }}';
                const id = '{{ $id }}';
                const values = @json($value);
                const options = @json($options);
                const keyValue = Boolean('<?= $keyValue ?>')
                const $context = $(`#input-tags-${id}`)
                const $input = $(`input[name=${name}]`, $context)
                const $handler = $(`#${id}`, $context)
                const $tags = $('div.tags', $context)
                const $datalist = $(`#data-${id}`)
                const tags = [];

                //create html tag
                const createTag = (text) => {
                    // Create the main tag element
                    const $tag = $('<span>').addClass('tag is-primary');
                    $tag.text(text);
                    const $delete = $('<button />', {
                        type: 'button'
                    }).addClass('delete is-small');
                    $tag.append($delete);
                    $delete.on('click', function(e) {
                        removeValue($tag, text)
                    })
                    return $tag;
                }

                //add value to tags
                const addValue = () => {
                    const tag = $handler.val()
                    let value;
                    //in case options are provided, 
                    if (!options || (keyValue && _.keys(options).length == 0) || (!keyValue && options
                            .length ==
                            0)) {
                        value = tag;
                    } else {
                        //allowed values are from that only
                        const $selected = $datalist.find(`[value='${tag}']`)
                        value = $selected.data('value')
                        if (_.findKey(options, (value, key) => value == tag) === undefined) {
                            $handler.val('')
                            return;
                        }
                    }
                    if (_.indexOf(tags, tag) == -1 && _.indexOf(values, value) == -1) {
                        tags.push(tag)
                        values.push(value)
                        createTag(tag).appendTo($tags)
                        window.Livewire.dispatch(`InputTagsChanged:${name}`, {
                            values: values
                        })
                    }
                    $input.val(JSON.stringify(values))
                    $handler.val('')
                }

                //remve value from tags
                const removeValue = ($tag, text) => {
                    $tag.remove()
                    _.pull(tags, text)
                    let value = text
                    if (options && keyValue) {
                        value = _.findKey(options, (value, key) => value == text)
                    }
                    _.remove(values, (v) => v == value)
                    if (tags.length == 0) {
                        $input.val('')
                    } else {
                        $input.val(JSON.stringify(values))
                    }
                    window.Livewire.dispatch(`InputTagsChanged:${name}`, {
                        values: values
                    })
                    // console.log(values);
                }

                const setValues = (_values) => {
                    tags.length = 0
                    values.length = 0
                    _values.forEach((element) => {
                        values.push(element)
                        const label = keyValue ? options[element] : element
                        tags.push(label)
                        createTag(label).appendTo($tags)
                    });
                    $input.val(JSON.stringify(values))
                    $handler.val('')
                }

                const initInputTags = (values) => {
                    if (values) {
                        setValues(values)
                    }
                    $handler
                        .off('keydown')
                        .on('keydown', function(e) {
                            if (e.keyCode == 13) {
                                addValue()
                            }
                        })
                    $handler.off('change').on('change', (e) => addValue())
                    $('button.delete', $context).on('click', function() {
                        removeValue($(this).parent(), $(this).data('text'))
                    })
                }

                const resetTags = () => {
                    tags.length = 0
                    $tags.empty()
                    $input.val('')
                }

                const preventFormSubmit = () => {
                    const $form = $context.closest('form')
                    if ($form.length > 0) {
                        $form.on('keydown', function(event) {
                            if (event.keyCode == 13) {
                                event.preventDefault();
                                return false;
                            }
                        })
                    }
                }
                preventFormSubmit();

                initInputTags()

                window.Livewire.on(`InitInputTags:${name}`, ({
                    values
                }) => {
                    initInputTags(values);
                })

                window.Livewire.on(`ResetInputTags:${name}`, () => {
                    resetTags();
                })
            });
        </script>
    @endscript
</div>
