<div class="vform-input-switch-wrapper">
    <div class="field">
        @if ($label)
            <label class="label">{{ $label }}</label>
        @endif

        <div class="control">
            <div class="switch-container">
                <label class="switch-toggle" for="{{ $id }}">
                    <input id="{{ $id }}" type="checkbox" name="{{ $name }}"
                        @if ($wireModel) wire:model.change="{{ $wireModel }}" @endif
                        {{ $attributes->merge(['class' => 'switch-input']) }}>
                    <span class="switch-slider switch-{{ $color }}">
                        <span class="switch-handle"></span>
                    </span>
                    @if ($on || $off)
                        <div class="switch-labels">
                            @if ($off)
                                <span class="switch-label switch-label-off">{{ $off }}</span>
                            @endif
                            @if ($on)
                                <span class="switch-label switch-label-on">{{ $on }}</span>
                            @endif
                        </div>
                    @endif
                </label>
            </div>
        </div>

        @if ($hint)
            <p class="help is-info">{{ $hint }}</p>
        @endif
        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>
</div>
